%% COMANDI DI PULIZIA E VISUALIZZAZIONE DATI
clc
clear all
close all
set(0,'defaultTextInterpreter','latex');          % serve a settare i grafici nei plot
set(0,'defaultAxesFontSize',20);
set(0,'defaultAxesFontName','TimesNewRoman');

Spessore=50;
ps=3;
x0=70;
test=1;
pa=101325;
D_foro=8;


%Caricamento Automatico Dati
Capacitivi=['load PattinoC60x30_f' num2str(D_foro) '_' num2str(Spessore) 'um_' num2str(ps) 'bar_x' num2str(x0) '_' num2str(test) '.txt'];
Dati_Capa=['Dati2=PattinoC60x30_f' num2str(D_foro) '_' num2str(Spessore) 'um_' num2str(ps) 'bar_x' num2str(x0) '_' num2str(test) ';'];

eval(Capacitivi)
eval(Dati_Capa)
%%%Cambio segno ai segnali misurati dai 4 sensori capacitivi (contenuti nella matrice 'dati') e pulisco il
%%%segnale con un filtro a media mobile che utilizza m punti
m=10;
x1s=smooth(-Dati2(:,1),m);
x2s=smooth(-Dati2(:,2),m);
x3s=smooth(-Dati2(:,3),m);
x4s=smooth(-Dati2(:,4),m);
Fs=smooth(Dati2(:,5),m);
Xv=smooth(Dati2(:,7),m);  %per le prove nuove xv8 e pr7
Pr=smooth(Dati2(:,8),m);
Gs=smooth(Dati2(:,6),m);

%Spostamento medio del pattino 
xm=(x1s+x2s+x3s+x4s)/4;
%Definisco lo zero
[ind1s ind1s]=max(abs(Fs));
[ind1s ind1s]=min(xm);
% [ind1s ind1s]=min(Gs);


x1s=x1s-x1s(ind1s);
x2s=x2s-x2s(ind1s);
x3s=x3s-x3s(ind1s);
x4s=x4s-x4s(ind1s);

%Plot dati sperimentali grezzi
figure
plot(x1s,Fs,'b',x2s,Fs,'r',x3s,Fs,'g',x4s,Fs,'k','linewidth',2,'MarkerSize',8),
xlabel('Pad Displacement $\quad x \: (\mu m)$'),ylabel('Load Capacity $ \quad F \: (N)$'), 
legend('$ x_1 $','$x_2$','$x_3$','$x_4$','interpreter','Latex')
grid on, zoom on
set(gca,'FontSize',32)
xlim([0 60])


figure
plot(x1s,Gs,'b',x2s,Gs,'r',x3s,Gs,'g',x4s,Gs,'k','linewidth',2,'MarkerSize',8),
xlabel('Pad Displacement $\quad x \: (\mu m)$'),ylabel('Flow Rate $ \quad Q \: (\frac{l}{min}) \quad ANR \quad 20^{\circ} $'), 
legend('$ x_1 $','$x_2$','$x_3$','$x_4$','interpreter','Latex')
grid on, zoom on
set(gca,'FontSize',32)
xlim([0 60])

xm=(x1s+x2s+x3s+x4s)/4;


% Calcolo rigidezza statica
[val ind]=max(Fs);
inizio=100;
fine=200;
xm1=xm(inizio:ind-fine);
Fs1=Fs(inizio:ind-fine);
Gs1=Gs(inizio:ind-fine);

K=zeros(size(Fs));
K(1)=-(Fs(2)-Fs(1))./(xm(2)-xm(1));
K(2:end-1)=-(Fs(3:end)-Fs(1:end-2))./(xm(3:end)-xm(1:end-2));
K(end)=-(Fs(end)-Fs(end-1))./(xm(end)-xm(end-1));
Ks=smooth(K,m*3);


%% Plot curve considerando lo spostamento medio

figure
plot(xm,Fs,'b','linewidth',2,'MarkerSize',8),
xlabel('Average displacement $\quad x \: (\mu m)$'),ylabel('Force $ \quad F \: (N)$'),
grid on, zoom on
% xlim([0 35])

figure
plot(xm,Gs,'b','linewidth',2,'MarkerSize',8),
xlabel('Average displacement $\quad x \: (\mu m)$'),ylabel('Air Mass Flow rate $ \quad Q \: (\frac{l}{min}ANR 20^{\circ} )$'), 
grid on, zoom on
% xlim([0 35])

% figure
% plot(xm1,Ks,'b','linewidth',2,'MarkerSize',8),hold on
% % plot(xm1(1:50:end),K(1:50:end),'ro','linewidth',2,'MarkerSize',8),
% xlabel('Average displacement $\quad x \: (\mu m)$'),ylabel('Stiffness $ \quad k_s \: (\frac{N}{\mu m})$'), 
% grid on, zoom on
% % xlim([0 35])

%% Salvataggio  parametrizzato
stringaxm=['xm_pattino' '_f' num2str(D_foro) '_' num2str(Spessore) 'um_' num2str(ps) 'bar_x' num2str(x0) '_' num2str(test) '=xm;'];
stringaF=['F_pattino' '_f' num2str(D_foro) '_' num2str(Spessore) 'um_' num2str(ps) 'bar_x' num2str(x0) '_' num2str(test) '=Fs;'];
stringaG=['G_pattino' '_f' num2str(D_foro) '_' num2str(Spessore) 'um_' num2str(ps) 'bar_x' num2str(x0) '_' num2str(test) '=Gs;'];
stringaK=['Ks_pattino' '_f' num2str(D_foro) '_' num2str(Spessore) 'um_' num2str(ps) 'bar_x' num2str(x0) '_' num2str(test) '=Ks;'];
stringaP=['Pr_pattino' '_f' num2str(D_foro) '_' num2str(Spessore) 'um_' num2str(ps) 'bar_x' num2str(x0) '_' num2str(test) '=Pr;'];
stringaxv=['xv_pattino' '_f' num2str(D_foro) '_' num2str(Spessore) 'um_' num2str(ps) 'bar_x' num2str(x0) '_' num2str(test) '=Xv;'];



 
stringa=['save PattinoC_f' num2str(D_foro) '_' num2str(Spessore) 'um_' num2str(ps) 'bar_x' num2str(x0) '_' num2str(test) ...
        ' xm_pattino' '_f' num2str(D_foro) '_' num2str(Spessore) 'um_' num2str(ps) 'bar_x' num2str(x0) '_' num2str(test) ...
        ' F_pattino' '_f' num2str(D_foro) '_' num2str(Spessore) 'um_' num2str(ps) 'bar_x' num2str(x0) '_' num2str(test) ...
        ' G_pattino' '_f' num2str(D_foro) '_' num2str(Spessore) 'um_' num2str(ps) 'bar_x' num2str(x0) '_' num2str(test) ...
        ' Ks_pattino' '_f' num2str(D_foro) '_' num2str(Spessore) 'um_' num2str(ps) 'bar_x' num2str(x0) '_' num2str(test) ...
        ' Pr_pattino' '_f' num2str(D_foro) '_' num2str(Spessore) 'um_' num2str(ps) 'bar_x' num2str(x0) '_' num2str(test) ...
        ' xv_pattino' '_f' num2str(D_foro) '_' num2str(Spessore) 'um_' num2str(ps) 'bar_x' num2str(x0) '_' num2str(test)];

eval(stringaxm)
eval(stringaF)
eval(stringaG)
eval(stringaK)
eval(stringaP)
eval(stringaxv)
eval(stringa)
